/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Geom;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogBlockConnector;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ScalableMouseEvent;
import DE.siemens.ad.pdraw.action.InsertConnectionAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockConnectorOwner;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.standard.ConnectionValidator;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.MouseInteractor;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.UDFConnectorFigure;
import DE.siemens.ad.udf.UDFLeftConnectorFigure;
import DE.siemens.ad.udf.UDFRightConnectorFigure;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockConnectionTool
extends LogoAbstractTool
implements MouseInteractor {
    protected IconTextTooltip fConnectionToolTip = null;
    private ConnectionValidator fConnectionValidator;
    private boolean fDragMode = true;
    protected Connector fStartConnector;
    protected Connector fEndConnector;
    private Connector fConnectorTarget = null;
    private Figure fTarget = null;
    protected ConnectionFigure fConnection;
    private ConnectionFigure fPrototype;
    private boolean fDrawMode;

    public IconTextTooltip getConnectionToolTip() {
        if (this.fConnectionToolTip == null) {
            this.fConnectionToolTip = new IconTextTooltip();
        }
        return this.fConnectionToolTip;
    }

    public BlockConnectionTool(ConnectionFigure prototype) {
        this.fPrototype = prototype;
        this.fConnectionValidator = new ConnectionValidator();
        this.fCursorName = "BlockConnectionToolCursor";
    }

    @Override
    public void activate(DrawingView view) {
        super.activate(view);
        view.clearSelection();
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    @Override
    public void deactivate(DrawingView view) {
        super.deactivate(view);
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        ConnectionFigure conFigure = this.createdFigure();
        if (conFigure != null) {
            try {
                Figure start = null;
                Connector conStart = this.getStartConnector();
                start = conStart.owner();
                Figure target = drawing.findFigureInsideWithout(x, y, conFigure);
                if (target != null && target.canConnect() && !target.includes(start) && conFigure.canConnect(start, target) && (start instanceof UDFConnectorFigure && target instanceof UDFConnectorFigure || start.container() != target.container())) {
                    return target;
                }
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return null;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fDrawMode) {
            this.handleMouseUp(e, x, y, view);
            this.fDrawMode = false;
            return;
        }
        if (!this.fDragMode) {
            this.fDrawMode = true;
        }
        if (this.handleDoubleClicked(e, view)) {
            return;
        }
        int ex = e.getX();
        int ey = e.getY();
        this.fTarget = this.findConnectionStart(ex, ey, view.drawing());
        if (this.fTarget != null) {
            this.fStartConnector = this.findConnector(ex, ey, this.fTarget);
            if (this.fStartConnector != null) {
                Point p = new Point(ex, ey);
                this.fConnection = this.createConnection();
                this.fConnection.startPoint(p.x, p.y);
                this.fConnection.endPoint(p.x, p.y);
                view.add(this.fConnection);
            }
        }
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        BlockConnector blockConnector;
        Figure target = drawing.findFigureInside(x, y);
        if (target == null) {
            target = drawing.findFigure(x, y);
        }
        if (target != null && target instanceof BlockConnectorOwner ? (blockConnector = ((BlockConnectorOwner)((Object)target)).getBlockConnector()) != null && blockConnector.isConnectable() : target != null && (target instanceof UDFLeftConnectorFigure || target instanceof UDFRightConnectorFigure)) {
            return target;
        }
        return null;
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        this.checkViewport(x, y, view);
        Point p = new Point(e.getX(), e.getY());
        if (this.fConnection != null) {
            this.trackConnectors(e, x, y, view);
            if (this.fTarget instanceof BlockConnectorOwner && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector() != null && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().isConnectable() || this.fTarget instanceof UDFConnectorFigure) {
                p = this.fTarget.getSnatchPoint(new Point(x, y));
                IconTextTooltip tooltip = this.getConnectionToolTip();
                tooltip.setBackground(IconTextTooltip.DEFAULT);
                if (this.fTarget instanceof BlockConnectorOwner) {
                    tooltip.setText(((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().getName());
                } else if (this.fTarget instanceof UDFConnectorFigure) {
                    tooltip.setText(this.getMiniBlockIdentifier(view));
                }
                tooltip.setIcon(null);
                if (e instanceof ScalableMouseEvent) {
                    x = ((ScalableMouseEvent)e).getUnscaledX();
                    y = ((ScalableMouseEvent)e).getUnscaledY();
                }
                this.fConnectionValidator.setView(view);
                this.fConnectionValidator.setTooltipLocation(e.getPoint());
                if (this.fConnectionValidator.checkInputOutputTypeCompatible(this.fStartConnector, this.fConnectorTarget) && (!(this.fStartConnector.owner() instanceof BlockConnectorOwner) || !(this.fTarget instanceof BlockConnectorOwner) || this.fConnectionValidator.checkSignalTypeCompatible((BlockConnectorOwner)((Object)this.fStartConnector.owner()), (BlockConnectorOwner)((Object)this.fTarget)) && this.fConnectionValidator.checkRecursionFree((BlockConnectorOwner)((Object)this.fStartConnector.owner()), (BlockConnectorOwner)((Object)this.fTarget))) && this.fConnectionValidator.checkMaxMiniNumber(view, this.fStartConnector, this.fConnectorTarget)) {
                    this.fConnectionValidator.hideTooltip();
                    ((LogoDrawingView)view).add(tooltip);
                    tooltip.setLocation(new Point(x + 10, y - 5));
                    tooltip.pack();
                    tooltip.setAutoHideTimeout(2000);
                    tooltip.setVisible(true);
                    tooltip.startAutoHide();
                }
            } else {
                this.getConnectionToolTip().setVisible(false);
                this.fConnectionValidator.hideTooltip();
            }
            this.fConnection.endPoint(p.x, p.y);
        }
    }

    private String getMiniBlockIdentifier(DrawingView view) {
        if (view instanceof LogoDrawingViewUDF && this.fStartConnector != null) {
            EditUDFFigure editUDFFigure = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure();
            Figure startIfcFigure = this.fStartConnector.owner();
            if (this.fTarget instanceof UDFLeftConnectorFigure) {
                if (startIfcFigure instanceof InputIfcFigure && ((InputIfcFigure)startIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    return "#AI" + String.valueOf(this.getMiniBlockNumber(view, editUDFFigure.getInputfigures(), true));
                }
                return "#I" + String.valueOf(this.getMiniBlockNumber(view, editUDFFigure.getInputfigures(), false));
            }
            if (this.fTarget instanceof UDFRightConnectorFigure) {
                if (startIfcFigure instanceof OutputIfcFigure && ((OutputIfcFigure)startIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    return "#AQ" + String.valueOf(this.getMiniBlockNumber(view, editUDFFigure.getOutputfigures(), true));
                }
                return "#Q" + String.valueOf(this.getMiniBlockNumber(view, editUDFFigure.getOutputfigures(), false));
            }
        }
        return "";
    }

    private int getMiniBlockNumber(DrawingView view, Vector<BlockFigure> figures, boolean analogFlg) {
        int i;
        if (figures == null || figures.size() == 0) {
            return 1;
        }
        int blockNumber = 0;
        int cnt = 0;
        int[] number = new int[figures.size()];
        for (i = 0; i < figures.size(); ++i) {
            EditUDFFigure.MiniBlockFigure mini = (EditUDFFigure.MiniBlockFigure)figures.get(i);
            if (analogFlg) {
                if (!(mini.getBlock() instanceof AnalogInputBlock) && !(mini.getBlock() instanceof AnalogOutputBlock)) continue;
                number[cnt] = mini.getBlock().getNumber();
                ++cnt;
                continue;
            }
            if (mini.getBlock() instanceof AnalogBlock) continue;
            number[cnt] = mini.getBlock().getNumber();
            ++cnt;
        }
        Arrays.sort(number, 0, cnt);
        for (i = 0; i < cnt; ++i) {
            if (number[i] == i + 1) continue;
            blockNumber = i + 1;
            break;
        }
        if (blockNumber == 0) {
            blockNumber = cnt + 1;
        }
        return blockNumber;
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fDrawMode) {
            this.mouseDrag(e, x, y, view);
            return;
        }
        this.trackConnectors(e, x, y, view);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fDrawMode) {
            return;
        }
        this.handleMouseUp(e, x, y, view);
        this.fStartConnector = null;
    }

    protected void handleMouseUp(MouseEvent e, int x, int y, DrawingView view) {
        FixedElbowConnection connection;
        if (this.fStartConnector == null) {
            return;
        }
        if (this.fConnection == null) {
            return;
        }
        view.remove(this.fConnection);
        this.getConnectionToolTip().setVisible(false);
        Figure figureUnderMouse = this.findTarget(e.getX(), e.getY(), view.drawing());
        if (figureUnderMouse == null) {
            return;
        }
        this.fEndConnector = this.findConnector(e.getX(), e.getY(), figureUnderMouse);
        if (this.fEndConnector == null) {
            return;
        }
        if (this.fStartConnector.owner() instanceof FixedElbowConnection) {
            connection = (FixedElbowConnection)this.fStartConnector.owner();
            connection.connectorVisibility(false);
            this.fConnection = new FixedElbowConnection();
            this.fConnection.connectStart(connection.start());
            this.fStartConnector = connection.start();
        }
        if (this.fEndConnector.owner() instanceof FixedElbowConnection) {
            connection = (FixedElbowConnection)this.fEndConnector.owner();
            connection.connectorVisibility(false);
            this.fConnection = new FixedElbowConnection();
            this.fConnection.connectEnd(connection.start());
            this.fEndConnector = connection.start();
        }
        if (view instanceof LogoDrawingViewUDF) {
            int maxInConnectorCount = ((LogoDrawingUDF)view.drawing()).getWiringDiagram().getHardware().getIntProperty("udfInConnectorCount");
            int maxOutConnectorCount = ((LogoDrawingUDF)view.drawing()).getWiringDiagram().getHardware().getIntProperty("udfOutConnectorCount");
            EditUDFFigure editUDFFigure = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure();
            if ((this.fEndConnector.owner() instanceof UDFLeftConnectorFigure || this.fStartConnector.owner() instanceof UDFLeftConnectorFigure) && editUDFFigure.getInputfigures().size() >= maxInConnectorCount) {
                return;
            }
            if ((this.fEndConnector.owner() instanceof UDFRightConnectorFigure || this.fStartConnector.owner() instanceof UDFRightConnectorFigure) && editUDFFigure.getOutputfigures().size() >= maxOutConnectorCount) {
                return;
            }
        }
        if (!(this.fEndConnector.owner() instanceof UDFConnectorFigure || this.fStartConnector.owner() instanceof UDFConnectorFigure || this.fEndConnector.owner() instanceof BlockConnectorOwner && this.fStartConnector.owner() instanceof BlockConnectorOwner)) {
            return;
        }
        Figure startIfcFigure = this.fStartConnector.owner();
        Figure endIfcFigure = this.fEndConnector.owner();
        if (startIfcFigure instanceof UDFLeftConnectorFigure && endIfcFigure instanceof BlockConnectorOwner) {
            if (((BlockConnectorOwner)((Object)endIfcFigure)).getBlockConnector().getInputOutputType() != 0 || endIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure) {
                return;
            }
        } else if (startIfcFigure instanceof UDFRightConnectorFigure && endIfcFigure instanceof BlockConnectorOwner) {
            if (((BlockConnectorOwner)((Object)endIfcFigure)).getBlockConnector().getInputOutputType() != 1 || endIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure) {
                return;
            }
        } else if (startIfcFigure instanceof BlockConnectorOwner && endIfcFigure instanceof UDFLeftConnectorFigure) {
            if (((BlockConnectorOwner)((Object)startIfcFigure)).getBlockConnector().getInputOutputType() != 0 || startIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure) {
                return;
            }
        } else if (startIfcFigure instanceof BlockConnectorOwner && endIfcFigure instanceof UDFRightConnectorFigure) {
            if (((BlockConnectorOwner)((Object)startIfcFigure)).getBlockConnector().getInputOutputType() != 1 || startIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure) {
                return;
            }
        } else {
            if (startIfcFigure instanceof UDFConnectorFigure && endIfcFigure instanceof UDFConnectorFigure || startIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure && endIfcFigure.container() instanceof EditUDFFigure.MiniBlockFigure) {
                return;
            }
            if (((BlockConnectorOwner)((Object)startIfcFigure)).getBlockConnector().getInputOutputType() == ((BlockConnectorOwner)((Object)endIfcFigure)).getBlockConnector().getInputOutputType()) {
                return;
            }
        }
        if (view instanceof LogoDrawingViewUDF) {
            EditUDFFigure.MiniBlockFigure mini = null;
            EditUDFFigure editUDFFigure = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure();
            int miniXLocation = editUDFFigure.getEditArea().x - editUDFFigure.getMiniFigureWidth() / 2;
            if (startIfcFigure instanceof UDFLeftConnectorFigure) {
                if (!((InBlockConnector)((BlockConnectorOwner)((Object)this.fEndConnector.owner())).getBlockConnector()).isConnectable()) {
                    return;
                }
                Boolean analog = false;
                if (endIfcFigure instanceof InputIfcFigure && ((InputIfcFigure)endIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    analog = true;
                }
                mini = editUDFFigure.addMiniBlockFigure(true, analog, new Point(miniXLocation, ((UDFLeftConnectorFigure)startIfcFigure).getFLastConnectorPosition().y));
                this.fStartConnector = ((Figure)mini.getOutputIfcFigures().get(0)).connectorAt(x, y);
            } else if (endIfcFigure instanceof UDFLeftConnectorFigure) {
                Boolean analog = false;
                if (startIfcFigure instanceof InputIfcFigure && ((InputIfcFigure)startIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    analog = true;
                }
                mini = editUDFFigure.addMiniBlockFigure(true, analog, new Point(miniXLocation, y));
                Connector tempConnector = this.fStartConnector;
                this.fStartConnector = ((Figure)mini.getOutputIfcFigures().get(0)).connectorAt(x, y);
                this.fEndConnector = tempConnector;
            } else if (startIfcFigure instanceof UDFRightConnectorFigure) {
                Boolean analog = false;
                if (endIfcFigure instanceof OutputIfcFigure && ((OutputIfcFigure)endIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    analog = true;
                }
                mini = editUDFFigure.addMiniBlockFigure(false, analog, new Point(miniXLocation + editUDFFigure.getEditArea().width, ((UDFRightConnectorFigure)startIfcFigure).getFLastConnectorPosition().y));
                Connector tempConnector = this.fEndConnector;
                this.fEndConnector = ((Figure)mini.getInputIfcFigures().get(0)).connectorAt(x, y);
                this.fStartConnector = tempConnector;
            } else if (endIfcFigure instanceof UDFRightConnectorFigure) {
                Boolean analog = false;
                if (startIfcFigure instanceof OutputIfcFigure && ((OutputIfcFigure)startIfcFigure).getBlockConnector() instanceof AnalogBlockConnector) {
                    analog = true;
                }
                mini = editUDFFigure.addMiniBlockFigure(false, analog, new Point(miniXLocation + editUDFFigure.getEditArea().width, y));
                this.fEndConnector = ((Figure)mini.getInputIfcFigures().get(0)).connectorAt(x, y);
            } else if (startIfcFigure instanceof InputIfcFigure) {
                Connector tempConnector = this.fStartConnector;
                this.fStartConnector = this.fEndConnector;
                this.fEndConnector = tempConnector;
            }
        } else if (startIfcFigure instanceof InputIfcFigure) {
            Connector tempConnector = this.fStartConnector;
            this.fStartConnector = this.fEndConnector;
            this.fEndConnector = tempConnector;
        }
        if (((BlockConnectorOwner)((Object)this.fEndConnector.owner())).getBlockConnector() instanceof ParameterInBlockConnector) {
            return;
        }
        if (!((InBlockConnector)((BlockConnectorOwner)((Object)this.fEndConnector.owner())).getBlockConnector()).isConnectable()) {
            return;
        }
        if (!((OutBlockConnector)((BlockConnectorOwner)((Object)this.fStartConnector.owner())).getBlockConnector()).isConnectable()) {
            return;
        }
        if (this.fConnectionValidator.areAlreadyConnected((BlockConnectorOwner)((Object)this.fEndConnector.owner()), (BlockConnectorOwner)((Object)this.fStartConnector.owner()))) {
            return;
        }
        if (!this.fConnectionValidator.checkRecursionFree((BlockConnectorOwner)((Object)this.fEndConnector.owner()), (BlockConnectorOwner)((Object)this.fStartConnector.owner()))) {
            LogoComfortStatusLine statusLine = (LogoComfortStatusLine)((LogoComfort)view.editor()).getStatusLine();
            statusLine.setTemporaryMessage(Language.getString("msg.recursion", "Recursions are only allowed over output and markers."), 5000, Color.red);
            return;
        }
        if (!this.fConnectionValidator.checkSignalTypeCompatible(this.fStartConnector, this.fEndConnector)) {
            return;
        }
        this.fConnection.connectStart(this.fStartConnector);
        this.fConnection.connectEnd(this.fEndConnector);
        ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
        InsertConnectionAction insertConnectionAction = (InsertConnectionAction)actionManager.getActionFactory().getAction("InsertConnectionAction");
        insertConnectionAction.setConnectionFigure(this.fConnection);
        if (startIfcFigure instanceof UDFLeftConnectorFigure || endIfcFigure instanceof UDFLeftConnectorFigure || startIfcFigure instanceof UDFRightConnectorFigure || endIfcFigure instanceof UDFRightConnectorFigure) {
            insertConnectionAction.setGenerateMiniBlockFigure(true);
        } else {
            insertConnectionAction.setGenerateMiniBlockFigure(false);
        }
        ((FixedElbowConnection)this.fConnection).setFrameColor(Color.BLUE);
        new LineColorFader(1000, 100, (FixedElbowConnection)this.fConnection, view);
        try {
            this.optimizeConnection((FixedElbowConnection)this.fConnection, (LogoDrawing)view.drawing());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fConnection = null;
        actionManager.invokeAction(insertConnectionAction);
    }

    protected void trackConnectors(MouseEvent e, int x, int y, DrawingView view) {
        Figure cursorFigure = null;
        cursorFigure = this.fStartConnector == null ? this.findConnectionStart(e.getX(), e.getY(), view.drawing()) : this.findTarget(e.getX(), e.getY(), view.drawing());
        if (cursorFigure != this.fTarget && this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
        this.fTarget = cursorFigure;
        if (this.fTarget != null) {
            if (this.fTarget instanceof BlockConnectorOwner && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector() != null && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().isConnectable()) {
                if (this.fStartConnector != null) {
                    if (this.fStartConnector.owner() instanceof UDFLeftConnectorFigure) {
                        if (!(this.fTarget instanceof UDFRightConnectorFigure) && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().getInputOutputType() == 0) {
                            this.fTarget.connectorVisibility(true);
                        }
                    } else if (this.fStartConnector.owner() instanceof UDFRightConnectorFigure) {
                        if (!(this.fTarget instanceof UDFLeftConnectorFigure) && ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().getInputOutputType() == 1) {
                            this.fTarget.connectorVisibility(true);
                        }
                    } else if (((BlockConnectorOwner)((Object)this.fStartConnector.owner())).getBlockConnector().getInputOutputType() != ((BlockConnectorOwner)((Object)this.fTarget)).getBlockConnector().getInputOutputType()) {
                        this.fTarget.connectorVisibility(true);
                    }
                } else {
                    this.fTarget.connectorVisibility(true);
                    this.fTarget.invalidate();
                }
            } else if (this.fTarget instanceof UDFLeftConnectorFigure || this.fTarget instanceof UDFRightConnectorFigure) {
                this.fTarget.connectorVisibility(true);
                this.fTarget.invalidate();
            }
        }
        Connector cc = null;
        if (cursorFigure != null) {
            cc = this.findConnector(e.getX(), e.getY(), cursorFigure);
        }
        if (cc != this.fConnectorTarget) {
            this.fConnectorTarget = cc;
        }
        view.checkDamage();
    }

    @Override
    public boolean handleDoubleClicked(MouseEvent e, DrawingView view) {
        Figure insideFigure;
        if (e.getClickCount() >= 2 && (insideFigure = view.drawing().findFigureInside(e.getX(), e.getY())) instanceof BlockIfcFigure) {
            view.clearSelection();
            view.addToSelection(insideFigure);
            LogoAction connectAction = null;
            LogoComfort logoComfort = (LogoComfort)view.editor();
            if (insideFigure instanceof InputIfcFigure) {
                connectAction = logoComfort.getActionFactory().getAction("ConnectInConnectorWithAction");
            }
            if (insideFigure instanceof OutputIfcFigure) {
                connectAction = logoComfort.getActionFactory().getAction("ConnectOutConnectorWithAction");
            }
            if (connectAction != null) {
                logoComfort.getActionManager().invokeAction(connectAction);
                return true;
            }
        }
        return super.handleDoubleClicked(e, view);
    }

    private void optimizeConnection(FixedElbowConnection fixedElbowConnection, LogoDrawing drawing) {
        List connectionList = (List)drawing.getOutputConnectionsDict().get(fixedElbowConnection.startFigure());
        if (connectionList == null) {
            return;
        }
        drawing.add(fixedElbowConnection);
        fixedElbowConnection.updateConnection();
        drawing.remove(fixedElbowConnection);
        Point startPoint = fixedElbowConnection.startPoint();
        Point endPoint = fixedElbowConnection.endPoint();
        long minLength = Geom.length(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        PolyLineFigure minLengthLine = null;
        int minLengthPoint = 0;
        for (FixedElbowConnection currentConnection : connectionList) {
            for (int i = 1; i < currentConnection.pointCount() - 1; i += 2) {
                Point segmentStart = currentConnection.pointAt(i);
                Point segmentEnd = currentConnection.pointAt(i + 1);
                if (segmentStart.y > segmentEnd.y) {
                    Point help = segmentStart;
                    segmentStart = segmentEnd;
                    segmentEnd = help;
                }
                long length = 0L;
                length = segmentStart.y <= endPoint.y && endPoint.y <= segmentEnd.y ? (long)Math.abs(endPoint.x - segmentStart.x) : (endPoint.y > segmentEnd.y ? Geom.length(endPoint.x, endPoint.y, segmentEnd.x, segmentEnd.y) : Geom.length(endPoint.x, endPoint.y, segmentStart.x, segmentStart.y));
                if (length >= minLength) continue;
                minLength = length;
                minLengthLine = currentConnection;
                minLengthPoint = i;
            }
        }
        if (minLengthLine != null) {
            for (int i = 0; i <= minLengthPoint; ++i) {
                fixedElbowConnection.setPointAt(new Point(minLengthLine.pointAt(i)), i);
            }
            fixedElbowConnection.setPointAt(new Point(minLengthLine.pointAt((int)minLengthPoint).x, fixedElbowConnection.pointAt((int)(minLengthPoint + 1)).y), minLengthPoint + 1);
        }
    }

    protected class LineColorFader
    implements ActionListener {
        private Timer fTimer;
        private FixedElbowConnection fConnection;
        private DrawingView fDrawingView;
        private int fTimeout;

        public LineColorFader(int initialDelay, int periodicDelay, FixedElbowConnection connection, DrawingView view) {
            this.fConnection = connection;
            this.fDrawingView = view;
            this.fTimer = new Timer(periodicDelay, this);
            this.fTimer.setInitialDelay(initialDelay);
            this.fTimer.start();
            this.fTimeout = 20;
        }

        public void actionPerformed(ActionEvent e) {
            this.fConnection.setFrameColor(this.darker(this.fConnection.getFrameColor()));
            if (this.fConnection.getFrameColor().equals(Color.black)) {
                this.fTimer.stop();
            }
            --this.fTimeout;
            if (this.fTimeout == 0) {
                this.fTimer.stop();
                this.fConnection.setFrameColor(Color.black);
            }
            this.fDrawingView.checkDamage();
        }

        public Color darker(Color color) {
            double factor = 0.9f;
            return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
        }
    }
}

